from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle_bottom, ready-pose)
        # "handle_bottom" is assumed to correspond to "drawer_bottom_handle" in Object_list
        # Approach handles along the x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        
        # Step 2: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # execute_pull uses mode=4, should be directed at the handle position
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except KeyError as e:
        print(f"Object key error: {e}")
    except Exception as e:
        print(f"An error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()