from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick the bottom drawer handle at the ready pose (axis=0 for handles)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # [Frozen Code Start/End]

        # Step 2: Pull (open) the bottom drawer using the handle, approach along x-axis (axis=0), increase distance for drawer open
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as e:
        print(f"Error during drawer opening sequence: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()