from Object_list import Object
from skill_mapping import RobotController

def pull_open_single_drawer(drawer_name, handle_name, location):
    """
    Pull open a single drawer by its handle.
    Args:
        drawer_name (str): The name of the drawer to open.
        handle_name (str): The name of the handle associated with the drawer.
        location (str): The location where the drawer and handle are.
    """
    robot = RobotController()
    # Pick the handle
    robot.execute_movement(Object[handle_name], mode=1, axis=0)
    # Pull to open the drawer
    robot.execute_movement(Object[handle_name], mode=4, distance=0.1)

# Example usage: open any drawer by specifying its handle and location
# For instance, to open the middle drawer:
# pull_open_single_drawer("drawer_middle", "drawer_middle_handle", "ready-pose") 

# To satisfy the TASK (generic, single drawer), do not call the function directly here.