from Object_list import Object
from skill_mapping import RobotController

def slide_one_drawer_open():
    """
    Slides one available drawer open.
    """
    robot = RobotController()
    # Find any available drawer handle
    for drawer_name in ["drawer_bottom", "drawer_middle", "drawer_top"]:
        handle_name = f"{drawer_name}_handle"
        if handle_name in Object:
            try:
                robot.execute_movement(Object[handle_name], mode=1, axis=0)
                robot.execute_movement(Object[handle_name], mode=4, axis=0, distance=0.1)
                break
            except Exception as error:
                continue

def main():
    slide_one_drawer_open()

if __name__ == "__main__":
    main()