"""Module to open any unlocked drawer using a robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Open up one of the drawers (the first unlocked and closed one found)."""
    robot = RobotController()
    # List of drawers and their corresponding handles
    drawers = [
        ("drawer_bottom", "drawer_bottom_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_top", "drawer_top_handle"),
    ]
    try:
        for drawer_name, handle_name in drawers:
            drawer = Object.get(drawer_name)
            handle = Object.get(handle_name)
            # Check if the drawer is unlocked and closed
            if robot.is_drawer_unlocked(drawer) and robot.is_drawer_closed(drawer):
                # If not holding anything, pick up the handle
                if robot.is_hand_empty():
                    robot.execute_movement(handle, mode=1, axis=0)
                # Unlock the drawer if needed
                if robot.is_drawer_locked(drawer):
                    robot.unlock_drawer(drawer)
                # Pull to open the drawer
                robot.execute_movement(handle, mode=4, distance=0.1)
                break
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to open a drawer."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()