"""Module to open any one drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """Open any one drawer (bottom, middle, or top) that is available."""
    robot = RobotController()
    # List of available drawers and their handles
    drawers = [
        ("drawer_bottom", "drawer_bottom_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_top", "drawer_top_handle"),
    ]
    for drawer_name, handle_name in drawers:
        handle_obj = Object.get(handle_name)
        if handle_obj is None:
            continue
        try:
            # Attempt to pick the handle
            robot.execute_movement(handle_obj, mode=1, axis=0)
            # Attempt to pull the drawer open
            robot.execute_movement(handle_obj, mode=4, axis=0)
            # If successful, stop after opening one drawer
            break
        except Exception:
            continue

def main():
    """Main entry point to open one drawer."""
    open_one_drawer()

if __name__ == "__main__":
    main()