"""Module to slide one drawer open using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def slide_one_drawer_open():
    """Slides any one closed and unlocked drawer open."""
    robot = RobotController()
    # List of available drawers and their handles
    drawers = [
        ("drawer_bottom", "handle_bottom"),
        ("drawer_middle", "handle_middle"),
        ("drawer_top", "handle_top"),
    ]
    for drawer_name, handle_name in drawers:
        drawer = Object.get(drawer_name)
        handle = Object.get(f"{drawer_name}_handle", Object.get(handle_name))
        if drawer is not None and handle is not None:
            # Optionally, check if the drawer is closed and unlocked here
            try:
                robot.execute_movement(handle, mode=1, axis=0)
                robot.execute_movement(handle, mode=4, axis=0, distance=0.1)
                break
            except Exception as error:
                print(f"Error opening {drawer_name}: {error}")

def main():
    """Main entry point to slide one drawer open."""
    slide_one_drawer_open()

if __name__ == "__main__":
    main()