"""Module to slide one drawer open using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def slide_one_drawer_open():
    """Slides any available closed and unlocked drawer open."""
    robot = RobotController()
    # List of drawers and their handles
    drawers = [
        ("drawer_bottom", "drawer_bottom_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_top", "drawer_top_handle"),
    ]
    for drawer_name, handle_name in drawers:
        drawer = Object.get(drawer_name)
        handle = Object.get(handle_name)
        if drawer is not None and handle is not None:
            # Check if the drawer is closed and unlocked
            if drawer.is_closed() and not drawer.is_locked():
                # Move to the handle and open the drawer
                robot.execute_movement(handle, mode=1, axis=0)
                robot.execute_movement(handle, mode=4, distance=0.1)
                break

def main():
    """Main entry point to slide one drawer open."""
    slide_one_drawer_open()

if __name__ == "__main__":
    main()