"""Module to open one available (unlocked and closed) drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """Open one available (unlocked and closed) drawer."""
    robot = RobotController()

    # List of drawers and their corresponding handles
    drawers = [
        ("drawer_bottom", "drawer_bottom_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_top", "drawer_top_handle"),
    ]

    # For this example, we assume Object contains keys for both drawers and handles
    for drawer_name, handle_name in drawers:
        drawer = Object.get(drawer_name)
        handle = Object.get(handle_name)
        if drawer is None or handle is None:
            continue

        # Check if the drawer is unlocked and closed
        if getattr(drawer, "is_unlocked", False) and getattr(drawer, "is_closed", False):
            # Pick the handle
            robot.execute_movement(handle, mode=1, axis=0)
            # Pull the handle to open the drawer
            robot.execute_movement(handle, mode=4, axis=0, distance=0.1)
            break

def main():
    """Main entry point to open one drawer."""
    open_one_drawer()

if __name__ == "__main__":
    main()