from Object_list import Object
from skill_mapping import RobotController

def pull_open_drawer():
    """Pull open a single drawer."""
    robot = RobotController()
    try:
        # Pick up a handle of a drawer (generic: pick the first available handle)
        handle = Object["drawer_bottom_handle"]
        robot.execute_movement(handle, mode=1, axis=0)
        # Pull open the corresponding drawer
        robot.execute_movement(handle, mode=4, distance=0.1)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to pull open a single drawer."""
    pull_open_drawer()

if __name__ == "__main__":
    main()