"""Module to open any available drawer."""
from Object_list import Object
from skill_mapping import RobotController

def open_any_drawer():
    """Attempts to open any available closed and unlocked drawer."""
    robot = RobotController()
    # List of drawers and their corresponding handles
    drawers = [
        ("drawer_bottom", "drawer_bottom_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_top", "drawer_top_handle"),
    ]
    for drawer_name, handle_name in drawers:
        try:
            # Check if the drawer is closed and unlocked
            if robot.is_drawer_closed(drawer_name) and robot.is_drawer_unlocked(drawer_name):
                # Move to the handle
                robot.execute_movement(Object[handle_name], mode=1, axis=0)
                # Pull to open the drawer
                robot.execute_movement(Object[handle_name], mode=4, axis=0, distance=0.1)
                return
        except Exception as error:
            print(f"Error while trying to open {drawer_name}: {error}")

def main():
    """Main entry point to open a drawer."""
    open_any_drawer()

if __name__ == "__main__":
    main()