from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick the handle_bottom at ready-pose, approach along x-axis (axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_bottom_handle: {e}")

    # Step 2: Pull the drawer_bottom using the handle at ready-pose (open drawer), approach along x-axis (axis=0 recommended)
    try:
        # The pull action expects mode=4. We supply the same handle's pose as the target for the action.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
