from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Task: Slide one drawer open.

    Oracle plan:
    1. execute_pick "handle_bottom" at "ready-pose"
    2. execute_pull "drawer_bottom" using "handle_bottom" at "ready-pose"

    Skills in use:
    - execute_pick: mode 1
    - execute_pull: mode 4

    Approach axis:
    - For drawer handles: axis = 0 (X-axis approach as per instruction)
    """

    robot = RobotController()

    try:
        # Step 1: Pick the bottom drawer handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_bottom_handle: {e}")

    try:
        # Step 2: Pull (slide open) the bottom drawer using its handle
        # 'distance' can be set to 0.1 for a reasonable drawer slide
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull on drawer_bottom: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()