from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up handle_bottom from ready-pose (execute_pick)
        # According to the skeleton guideline, approach along axis=0 (x-axis) for handles.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull open drawer_bottom using handle_bottom at ready-pose (execute_pull)
        # Stay at the same location; use axis=0 (x-axis) for pulling.
        # Use a slightly larger distance for clear drawer opening.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during plan execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()