from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    # Step 1: Pick handle1 (drawer_top_handle corresponds to handle1)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_top_handle: {e}")

    # Step 2: Pull drawer1 open (pull using handle1 at x-axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull on drawer1 with handle1: {e}")

    # Step 3: Pick handle2 (drawer_middle_handle corresponds to handle2)
    try:
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_middle_handle: {e}")

    # Step 4: Pull drawer2 open (pull using handle2 at x-axis)
    try:
        robot.execute_movement(Object["drawer_middle_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull on drawer2 with handle2: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()