from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    # Step 1: Pick handle3 (drawer3's handle). Approaching along handle axis (x-axis, axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in picking handle3 (drawer3 handle): {e}")

    # Step 2: Pull to open drawer3. Use the same handle pose, mode=4, axis=0, distance=0.03
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.03)
    except Exception as e:
        print(f"Error in pulling (opening) drawer3: {e}")

    # Step 3: Pick handle1 (drawer1's handle). Approaching along handle axis (x-axis, axis=0)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in picking handle1 (drawer1 handle): {e}")

    # Step 4: Pull to open drawer1. Use the same handle pose, mode=4, axis=0, distance=0.03
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.03)
    except Exception as e:
        print(f"Error in pulling (opening) drawer1: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
