from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle3, ready-pose)
        # 'handle3' maps to Object["drawer_bottom_handle"] (assuming handle3 = bottom handle in object list)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in step 1 (execute_pick handle3): {e}")

    try:
        # Step 2: execute_pull(drawer3, handle3, ready-pose)
        # 'drawer3' corresponds to the bottom drawer (pull after picking handle3)
        # mode=4 for pull; axis=0 (x direction); distance typically 0.1m for drawer pull
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in step 2 (execute_pull drawer3): {e}")

    try:
        # Step 3: execute_pick(handle1, ready-pose)
        # 'handle1' maps to Object["drawer_top_handle"]
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in step 3 (execute_pick handle1): {e}")

    try:
        # Step 4: execute_pull(drawer1, handle1, ready-pose)
        # 'drawer1' corresponds to the top drawer (pull after picking handle1)
        # mode=4 for pull; axis=0 (x direction); distance=0.1
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in step 4 (execute_pull drawer1): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
