from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move to drawer3 location (drawer3 represents the bottom drawer: "drawer_bottom_handle")
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)  # execute_go: ready-pose → drawer3

        # Step 2: Pick handle3 (drawer3 handle) - approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # execute_pick: handle3

        # Step 3: Pull to open drawer3 using its handle - approach along x-axis
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 4: Move to drawer2 location ("drawer_middle_handle")
        robot.execute_movement(Object["drawer_middle_handle"], mode=7)  # execute_go: drawer3 → drawer2

        # Step 5: Pick handle2 (drawer2 handle) - approach along x-axis
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)  # execute_pick: handle2

        # Step 6: Pull to open drawer2 using its handle
        robot.execute_movement(Object["drawer_middle_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()