from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle3, ready-pose)
        # Mapping: handle3 is "drawer_bottom_handle", which corresponds to the handle of drawer3.
        #         ready-pose: not a point, but plan says pick at ready-pose (robot is there).
        # In this context, picking the bottom handle means: approach handle along axis=0 (X axis).
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: execute_pull(drawer3, handle3, ready-pose)
        # Mapping: drawer3 is associated with handle3; we just picked it above.
        # To pull (open) the drawer, approach along X (axis=0). Distance: open wide enough, to be safe set e.g. 0.1.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as e:
        print(f"Error during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
