from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: execute_pick(handle3, drawer-area)
    # Mapping to Sim2Real object names: handle3 -> drawer_bottom_handle, drawer-area -> location not used directly.
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_bottom_handle: {e}")

    # Step 2: execute_pull(drawer3, handle3, drawer-area)
    # Mapping: drawer3 -> bottom drawer, handle3 -> drawer_bottom_handle
    # The passed object is the handle's pose, matching previous skill usage.
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom_handle: {e}")


def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()