from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick handle_bottom at ready-pose (use axis=0 for handle)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 2: Pull drawer_bottom using handle_bottom at ready-pose (mode=4, axis=0, reasonable distance for drawer opening)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
        # Step 3: Pick handle_top at ready-pose (use axis=0 for handle)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 4: Pull drawer_top using handle_top at ready-pose (mode=4, axis=0, reasonable distance for drawer opening)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Exception during oracle sequence: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()