from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick handle_bottom at ready-pose (approach axis 0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for handle_bottom: {e}")

    try:
        # Step 2: Pull to open drawer_bottom using handle_bottom at ready-pose
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom: {e}")

    try:
        # Optional: move/go action to reposition after first pull
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error in execute_go: {e}")

    try:
        # Step 3: Pick handle_top at ready-pose (approach axis 0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for handle_top: {e}")

    try:
        # Step 4: Pull to open drawer_top using handle_top at ready-pose
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_top: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()