from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Move from 'ready-pose' to 'drawer-area'
        robot.execute_movement(mode=7)

        # Step 1: Pick handle_bottom (for drawer_bottom) along x-axis
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull (open) drawer_bottom using handle_bottom
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

        # Step 3: Pick handle_top (for drawer_top) along x-axis
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 4: Pull (open) drawer_top using handle_top
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)

    except KeyError as e:
        print(f"Object key error: {e}")
    except Exception as e:
        print(f"An unexpected error occurred during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()