from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick the handle of the top drawer at ready-pose (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick: {e}")

    # Step 2: Move from ready-pose to drawer-area
    try:
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error in execute_go: {e}")

    # Step 3: Pull to open the top drawer at drawer-area (handle still held, approach along x-axis, longer distance)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Error in execute_pull: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()