from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Move from 'ready-pose' to 'drawer-area' (execute_go)
    try:
        # execute_go is mapped to mode = 7. No pose object is needed.
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error in execute_go from ready-pose to drawer-area: {e}")

    # Step 2: Pick handle_bottom at 'drawer-area' (execute_pick, axis=0 for x-axis approach)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for handle_bottom: {e}")

    # Step 3: Pull (open) drawer_bottom with handle_bottom at 'drawer-area' (execute_pull)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom: {e}")

    # Step 4: Pick handle_top at 'drawer-area' (execute_pick, axis=0 for x-axis approach)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for handle_top: {e}")

    # Step 5: Pull (open) drawer_top with handle_top at 'drawer-area' (execute_pull)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_top: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()