"""Module to open any two drawers using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Open any two drawers by unlocking and pulling them."""
    robot = RobotController()

    # Open drawer_bottom
    robot.execute_movement(Object["drawer_bottom_handle"], mode=2, axis=0)  # Unlock bottom drawer
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # Pick handle
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)  # Pull to open

    # Open drawer_middle
    robot.execute_movement(Object["drawer_middle_handle"], mode=2, axis=0)  # Unlock middle drawer
    robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)  # Pick handle
    robot.execute_movement(Object["drawer_middle_handle"], mode=4, axis=0, distance=0.1)  # Pull to open

def main():
    """Main entry point to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()