from Object_list import Object
from skill_mapping import RobotController

def open_two_drawers():
    """
    Opens any two drawers using the robot controller.
    """
    robot = RobotController()
    drawers = [
        ("drawer_bottom_handle", 0),
        ("drawer_middle_handle", 0),
        ("drawer_top_handle", 0)
    ]
    opened = 0
    for handle_name, axis in drawers:
        if opened >= 2:
            break
        robot.execute_movement(Object[handle_name], mode=1, axis=axis)
        robot.execute_movement(Object[handle_name], mode=4, axis=axis, distance=0.1)
        opened += 1

def main():
    """
    Main function to open two drawers.
    """
    open_two_drawers()

if __name__ == "__main__":
    main()