from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq(drawer_handles):
    """
    Pull open a pair of drawers specified by their handle names.
    :param drawer_handles: List of two handle names (e.g., ["drawer_bottom_handle", "drawer_top_handle"])
    """
    robot = RobotController()
    for handle_name in drawer_handles:
        robot.execute_movement(Object[handle_name], mode=1, axis=0)
        robot.execute_movement(Object[handle_name], mode=4, distance=0.1)

def main():
    # Example: open any two drawers (here, bottom and top)
    drawer_handles = ["drawer_bottom_handle", "drawer_top_handle"]
    long_horizon_task2_oracle_seq(drawer_handles)

if __name__ == "__main__":
    main()