"""Module to open all unlocked drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def open_all_unlocked_drawers():
    """Open all drawers that are currently unlocked."""
    robot = RobotController()

    # List of all drawers and their corresponding handles
    drawers = [
        {"drawer": "drawer_bottom", "handle": "handle_bottom", "handle_obj": "drawer_bottom_handle"},
        {"drawer": "drawer_middle", "handle": "handle_middle", "handle_obj": "drawer_middle_handle"},
        {"drawer": "drawer_top", "handle": "handle_top", "handle_obj": "drawer_top_handle"},
    ]

    for d in drawers:
        # Check if the drawer is unlocked
        if robot.is_drawer_unlocked(d["drawer"]):
            # Pick up the handle if not already holding it
            if not robot.is_holding(d["handle"]):
                robot.execute_movement(Object[d["handle_obj"]], mode=1, axis=0)
            # Pull the drawer open using the handle
            robot.execute_movement(Object[d["handle_obj"]], mode=4, distance=0.1)

def main():
    """Main function to open all unlocked drawers."""
    open_all_unlocked_drawers()

if __name__ == "__main__":
    main()