"""Module to uncover every drawer that isn’t locked by opening only unlocked drawers."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Uncover every drawer that isn’t locked by opening only unlocked drawers."""
    robot = RobotController()

    # List of drawers and their corresponding handles
    drawers = [
        {"drawer": "drawer_bottom", "handle": "drawer_bottom_handle"},
        {"drawer": "drawer_middle", "handle": "drawer_middle_handle"},
        {"drawer": "drawer_top", "handle": "drawer_top_handle"},
    ]

    for item in drawers:
        drawer_name = item["drawer"]
        handle_name = item["handle"]

        # Check if the drawer is unlocked before attempting to open
        try:
            if robot.is_drawer_unlocked(drawer_name):
                try:
                    robot.execute_movement(Object[handle_name], mode=1, axis=0)
                except Exception as pick_error:
                    print(f"Error in execute_pick for {handle_name}: {pick_error}")
                    continue

                try:
                    robot.execute_movement(Object[handle_name], mode=4, distance=0.1)
                except Exception as pull_error:
                    print(f"Error in execute_pull for {handle_name}: {pull_error}")
            else:
                print(f"Skipped {drawer_name}: drawer is locked.")
        except Exception as state_error:
            print(f"Error checking lock state for {drawer_name}: {state_error}")

def main():
    """Main entry point to uncover unlocked drawers."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()