"""Module to open any two unlocked drawers using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Open any two unlocked drawers."""
    robot = RobotController()
    drawers_to_open = []

    # List of drawers and their corresponding handles
    drawers = [
        ("drawer_top", "drawer_top_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_bottom", "drawer_bottom_handle"),
    ]

    # Check which drawers are unlocked in the initial state
    # For this code, we assume the robot can query the state or we hardcode based on the observation
    # In the given observation, only drawer_top is unlocked
    unlocked_drawers = ["drawer_top"]  # Add more if more are unlocked

    # Try to open any two unlocked drawers
    for drawer_name, handle_name in drawers:
        if drawer_name in unlocked_drawers:
            drawers_to_open.append((drawer_name, handle_name))
        if len(drawers_to_open) == 2:
            break

    # If less than two unlocked drawers, try to open as many as possible
    for drawer_name, handle_name in drawers_to_open:
        try:
            # Pick the handle
            robot.execute_movement(Object[handle_name], mode=1, axis=0)
            # Pull the drawer using the handle
            robot.execute_movement(Object[handle_name], mode=4, distance=0.1)
        except Exception as error:
            print(f"Error during task execution: {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()