"""Module to open all unlocked drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def open_all_unlocked_drawers():
    """Open all unlocked drawers by picking their handles and pulling."""
    robot = RobotController()

    # List of all drawers and their corresponding handles
    drawers = [
        ("drawer_top", "drawer_top_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_bottom", "drawer_bottom_handle"),
    ]

    for drawer_name, handle_name in drawers:
        drawer = Object.get(drawer_name)
        handle = Object.get(handle_name)
        if drawer is None or handle is None:
            continue

        # Check if the drawer is unlocked and closed
        if getattr(drawer, "is_unlocked", False) and getattr(drawer, "is_closed", False):
            try:
                # Move to the handle and pick it
                robot.execute_movement(handle, mode=1, axis=0)
                # Pull to open the drawer
                robot.execute_movement(handle, mode=4, distance=0.1)
            except Exception as error:
                print(f"Error opening {drawer_name}: {error}")

def main():
    """Main entry point to open all unlocked drawers."""
    open_all_unlocked_drawers()

if __name__ == "__main__":
    main()