from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Slide open two of the drawers (any two that are possible).
    """
    robot = RobotController()

    # Move from ready-pose to drawer-area
    robot.execute_movement(mode=7)  # execute_go

    # Open drawer_top (unlocked and closed in initial state)
    robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick
    robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)  # execute_pull

    # Open drawer_bottom (assumed to be unlocked and closed if present)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # execute_pick
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)  # execute_pull

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()