"""Module to uncover (open) every drawer that isn’t locked."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Open every drawer that is unlocked and closed."""
    robot = RobotController()

    # List of all drawers and their corresponding handles
    drawers = [
        {"drawer": "drawer_top", "handle": "drawer_top_handle"},
        {"drawer": "drawer_middle", "handle": "drawer_middle_handle"},
        {"drawer": "drawer_bottom", "handle": "drawer_bottom_handle"},
    ]

    for d in drawers:
        drawer_name = d["drawer"]
        handle_name = d["handle"]

        # Check if the drawer is unlocked and closed
        if robot.is_drawer_unlocked(drawer_name) and robot.is_drawer_closed(drawer_name):
            # Move to the handle
            robot.execute_movement(Object[handle_name], mode=1, axis=0)
            # Pull to open the drawer
            robot.execute_movement(Object[handle_name], mode=4, distance=0.1)

def main():
    """Main entry point to execute the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()