from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Open two drawers that are unlocked and closed."""
    robot = RobotController()
    try:
        # Open drawer_top if unlocked and closed
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Open another unlocked and closed drawer if available (drawer_middle is locked, so skip)
        # If more drawers are added and unlocked, add them here
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()