"""Module to pull open any pair of unlocked drawers."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Pull open any pair of unlocked drawers."""
    robot = RobotController()
    # List of all drawers and their corresponding handles
    drawers = [
        ("drawer_top", "drawer_top_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_bottom", "drawer_bottom_handle"),
    ]
    # Identify unlocked drawers
    unlocked_drawers = []
    for drawer_name, handle_name in drawers:
        if Object[drawer_name].is_unlocked():
            unlocked_drawers.append((drawer_name, handle_name))
    # Pull open any pair of unlocked drawers
    opened = 0
    for drawer_name, handle_name in unlocked_drawers:
        # Pick the handle
        robot.execute_movement(Object[handle_name], mode=1, axis=0)
        # Pull to open the drawer
        robot.execute_movement(Object[handle_name], mode=4, distance=0.1)
        opened += 1
        if opened == 2:
            break

def main():
    """Main entry point to execute the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()