from Object_list import Object
from skill_mapping import RobotController

def open_all_unlocked_drawers():
    """
    Opens all unlocked and closed drawers by picking their handles and pulling them open.
    """
    robot = RobotController()

    # List of all drawers and their corresponding handles
    drawers_and_handles = [
        ("drawer_top", "drawer_top_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_bottom", "drawer_bottom_handle"),
    ]

    for drawer_name, handle_name in drawers_and_handles:
        drawer = Object.get(drawer_name)
        handle = Object.get(handle_name)
        if drawer is None or handle is None:
            continue

        # Check if the drawer is unlocked and closed
        if getattr(drawer, "is_unlocked", False) and getattr(drawer, "is_closed", False):
            try:
                # Pick the handle
                robot.execute_movement(handle, mode=1, axis=0)
                # Pull to open the drawer
                robot.execute_movement(handle, mode=4, distance=0.1)
            except Exception as error:
                print(f"Error opening {drawer_name}: {error}")

def main():
    open_all_unlocked_drawers()

if __name__ == "__main__":
    main()