from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Slide open any two drawers that can be opened.
    """
    robot = RobotController()

    # List of drawers and their corresponding handles
    drawers = [
        ("drawer_top", "drawer_top_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_bottom", "drawer_bottom_handle"),
    ]

    drawers_opened = 0

    # Move to drawer-area if not already there
    robot.execute_movement(mode=7)

    for drawer_name, handle_name in drawers:
        if drawers_opened >= 2:
            break
        # Check if the drawer is unlocked and closed
        if robot.is_drawer_unlocked(drawer_name) and robot.is_drawer_closed(drawer_name):
            # Pick the handle
            robot.execute_movement(Object[handle_name], mode=1, axis=0)
            # Pull to open the drawer
            robot.execute_movement(Object[handle_name], mode=4, axis=0, distance=0.1)
            drawers_opened += 1

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()