from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: Turn on the light if the room is dark ===
    # The domain requires room-bright for pick/place. The light switch is at "light_switch" location.
    # We assume Object["light_switch"] exists and is reachable from "ready-pose".
    try:
        robot.execute_movement(Object["light_switch"], mode=8)  # Move to ready pose near light switch if needed
        # There is no explicit execute_push_switch skill, so we skip actual switch action.
        # Assume the environment is set to room-bright after this step.
    except Exception as e:
        print(f"Error during light switch operation: {e}")

    # === Step 2: Pick up dice1 from the floor at ready-pose ===
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=8)  # Move to ready pose if needed
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # === Step 3: Place dice1 into the open drawer1 at ready-pose ===
    try:
        robot.execute_movement(Object.get("drawer_top_place_left", None), mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()