from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick up dice1 from ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Go to ready pose if needed
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Ensure at ready pose
    except Exception:
        pass  # If already at ready pose, ignore

    try:
        # Pick up dice1 (assume dice1 is at ready-pose, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Go to ready pose
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Redundant, but safe
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)
    except Exception:
        pass

    try:
        # Actually execute the pick (mode=1, axis=2 for z-axis approach)
        robot.execute_movement(Object["drawer_top_place_left"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick: {e}")

    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Go to ready pose after pick
    except Exception:
        pass

    # Step 2: Place dice1 into drawer1 at ready-pose
    try:
        # Place (mode=2, axis=2 for z-axis approach)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place: {e}")

    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Return to ready pose
    except Exception:
        pass

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
