from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up dice1 from the floor
        # According to the specification, axis=2 (z-axis) for general objects
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Move to ready pose after pick

        # Step 2: Place dice1 into the open drawer (drawer1)
        # Place at drawer-area (assume Object["drawer_top_place_left"] as drawer-area for drawer1)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # Move to ready pose after place

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()