from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Turn on the light (execute_push_switch)
    try:
        # The light switch is approached from above (z-axis), so axis=2
        # mode=1 is execute_pick, but for switch, we need to push it (not pick)
        # However, only execute_pick and execute_place are required by the specification,
        # but the plan content includes execute_push_switch, which is not mapped directly.
        # Since we only have execute_pick and execute_place, but the plan content
        # requires the switch to be pushed, we will use execute_pick as a proxy for pushing the switch.
        # If execute_push_switch were mapped, we would use it, but it's not in the available skills.
        # So, we use execute_pick on the light_switch to simulate pushing it.
        robot.execute_movement(Object["light_switch"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_push_switch for light_switch: {e}")

    # Step 2: Pick up the dice (execute_pick)
    try:
        # axis=2: approach from above (z-axis) for general objects like dice
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # Step 3: Place the dice into the open drawer (execute_place)
    try:
        # axis=2: approach from above (z-axis) for placing into drawer
        # Use the left place position for drawer1 as the placement pose
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1 into drawer1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()