from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Turn on the light (execute_push_switch)
    # There is no direct skill for execute_push_switch, so we simulate this by using execute_pick on the light switch.
    try:
        robot.execute_movement(Object["light_switch"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose after action
    except Exception as e:
        print(f"Error during execute_push_switch: {e}")

    # Step 2: execute_pick dice1 at ready-pose
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose after pick
    except Exception as e:
        print(f"Error during execute_pick: {e}")

    # Step 3: execute_place dice1 in drawer1 at ready-pose
    # The place location for drawer1 is drawer_top_place_left (as per object list mapping)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose after place
    except Exception as e:
        print(f"Error during execute_place: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()