from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 0: Turn on the light (required for pick/place)
        robot.execute_movement(Object["light_switch"], mode=3, axis=2, distance=0.03)

        # Step 1: Pick up the dice (dice1) from ready-pose (axis=2 for general object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: Place the dice into the open drawer
        # The place location for the open drawer is mapped to "drawer_top_place_left" in Object_list.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()