from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Turn on the light (execute_push_switch)
    try:
        # Open gripper at light switch (simulate approach)
        robot.execute_movement(Object["light_switch"], mode=9)
        # Close gripper at light switch (simulate press)
        robot.execute_movement(Object["light_switch"], mode=10)
    except Exception as e:
        print(f"Error during execute_push_switch for light_switch: {e}")

    # Step 2: Pick up dice1 from ready-pose (axis=2 for general objects)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # Step 3: Place dice1 into the already open drawer at ready-pose (axis=2)
    # According to the object list and typical mapping, use "drawer_top_place_left" as the place pose for the open drawer
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1 into drawer: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()