from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: Turn on the light (execute_push_switch) ===
    try:
        # The light switch is "light_switch", location is "ready-pose"
        # In this codebase, we use Object["light_switch"] for the pose
        # execute_push_switch is not directly mapped, but mode=3 is push (for drawer), so we use mode=3 for push-like actions
        # However, for the light switch, we need to push it. We'll use mode=3, axis=2 (z-axis) for general push
        robot.execute_movement(Object["light_switch"], mode=3, axis=2, distance=0.03)
    except Exception as e:
        print(f"Error during execute_push_switch for light_switch: {e}")

    # === Step 2: Pick up dice1 from the floor at ready-pose ===
    try:
        # axis=2: approach from z-axis for general objects
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # === Step 3: Place dice1 into the open drawer at ready-pose ===
    try:
        # The plan specifies (execute_place dice1 drawer1 ready-pose)
        # We map drawer1 to a known place position in the top drawer (e.g., drawer_top_place_left)
        # axis=2: approach from z-axis for general objects
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1 into drawer: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()