from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 0: Turn on the light (execute_push_switch)
        # There is no direct skill for execute_push_switch, so we use execute_pick on the light_switch as a proxy.
        robot.execute_movement(Object["light_switch"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Move to ready pose after switch

        # Step 1: Pick up dice1 from the floor (execute_pick)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Move to ready pose after pick

        # Step 2: Place dice1 into the open drawer (execute_place)
        # We assume the correct place pose for the open drawer is "drawer_top_place_left"
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # Move to ready pose after place

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()