from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: (execute_push_switch light_switch ready-pose)
        # There is no direct skill for execute_push_switch in the provided skills,
        # so we assume the light is already on or this step is handled elsewhere.

        # Step 2: (execute_pick dice1 ready-pose)
        # axis=2 for general objects (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 3: (execute_place dice1 drawer1 ready-pose)
        # The drawer is already open, so we place the dice into the drawer.
        # Use a drawer place location (e.g., drawer_top_place_left) as the target.
        # axis=2 for placing general objects
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()