from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Turn on the light (execute_push_switch)
    try:
        robot.execute_movement(Object["light_switch"], mode=3, axis=2)
    except Exception as e:
        print(f"Error during execute_push_switch for light_switch: {e}")

    # Step 2: Pick up the dice (execute_pick)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # Step 3: Place the dice into the open drawer (execute_place)
    try:
        # The placement location for the top drawer is mapped to "drawer_top_place_left"
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1 into drawer: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()