# run_skeleton_task.py (Completed with Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # The feedback indicates a missing predicate is causing planning to fail.
        # We will attempt to execute each available skill in a safe, exploratory way
        # to see which predicates are required but missing.

        # List of available skills
        available_skills = [
            'execute_pick', 'execute_place', 'execute_push', 'execute_pull',
            'execute_sweep', 'execute_rotate', 'execute_go', 'execute_gripper'
        ]

        # For demonstration, we will attempt to call each skill with plausible arguments.
        # If a skill fails due to a missing predicate, we log the error for analysis.

        # Example object and location selection for exploration
        # (Replace with actual object/location names from your environment if known)
        # We'll try to get at least one object, one drawer, one location, one handle, one switch
        object_names = [name for name in positions if 'object' in name or 'obj' in name]
        drawer_names = [name for name in positions if 'drawer' in name]
        handle_names = [name for name in positions if 'handle' in name]
        switch_names = [name for name in positions if 'switch' in name]
        location_names = [name for name in positions if 'location' in name or 'room' in name or 'pos' in name]

        # Fallbacks if not found
        if not object_names and positions:
            object_names = list(positions.keys())
        if not location_names and positions:
            location_names = list(positions.keys())

        # Select first available for each type
        obj = object_names[0] if object_names else None
        drawer = drawer_names[0] if drawer_names else None
        handle = handle_names[0] if handle_names else None
        switch = switch_names[0] if switch_names else None
        loc = location_names[0] if location_names else None
        loc2 = location_names[1] if len(location_names) > 1 else loc

        print("[Exploration] Starting exploration to identify missing predicates...")
        for skill in available_skills:
            try:
                print(f"[Exploration] Attempting skill: {skill}")
                if skill == 'execute_pick' and obj and loc:
                    obs, reward, done = execute_pick(env, task, obj, loc)
                elif skill == 'execute_place' and obj and drawer and loc:
                    obs, reward, done = execute_place(env, task, obj, drawer, loc)
                elif skill == 'execute_push' and drawer and loc:
                    obs, reward, done = execute_push(env, task, drawer, loc)
                elif skill == 'execute_pull' and drawer and handle and loc:
                    obs, reward, done = execute_pull(env, task, drawer, handle, loc)
                elif skill == 'execute_sweep' and obj and loc:
                    obs, reward, done = execute_sweep(env, task, obj, loc)
                elif skill == 'execute_rotate':
                    obs, reward, done = execute_rotate(env, task)
                elif skill == 'execute_go' and loc and loc2:
                    obs, reward, done = execute_go(env, task, loc, loc2)
                elif skill == 'execute_gripper':
                    obs, reward, done = execute_gripper(env, task)
                else:
                    print(f"[Exploration] Skipping skill {skill} due to missing arguments.")
                    continue
                print(f"[Exploration] Skill {skill} executed successfully.")
            except Exception as e:
                print(f"[Exploration] Skill {skill} failed: {e}")

        print("[Exploration] Exploration phase complete. Check above for missing predicate clues.")

        # === Main Task Plan Execution ===
        # TODO: Replace this with the actual oracle plan steps for your task.
        # For now, we simply demonstrate the exploration phase.

        # Example: If you know the plan, you would do something like:
        # obs, reward, done = execute_go(env, task, 'room1', 'room2')
        # obs, reward, done = execute_pick(env, task, 'object1', 'room2')
        # obs, reward, done = execute_place(env, task, 'object1', 'drawer1', 'room2')
        # ... etc.

        # You can insert your oracle plan here, using only the predefined skills.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
